#!/usr/bin/env python
# -*- coding: utf-8 -*-

import DonaldDuckModel
import DonaldDuckDataset
import os
import DonaldDuckConv
import tensorflow as tf

if __name__=='__main__':
    os.environ["CUDA_DEVICE_ORDER"] = "PCI_BUS_ID"
    os.environ["CUDA_VISIBLE_DEVICES"] = "0"
    physical_devices = tf.config.list_physical_devices('GPU')
    try:
        tf.config.experimental.set_memory_growth(physical_devices[0], True)
        assert tf.config.experimental.get_memory_growth(physical_devices[0])
    except:
        pass
    
    # you could change dataset and victim model by commenting directly on the code
    dataset=DonaldDuckDataset.CIFAR10(standardization=False, data_aug_flag=True)
    cnn = DonaldDuckConv.DonaldDuckVGG16(
        dataset,
        batch_size=128,
        epochs=50,
    )
    cnn.setModel()
    
#     dataset=DonaldDuckDataset.MNIST(standardization=False)
#     dataset=DonaldDuckDataset.Fashion(standardization=False)
#     conv_layers_num = 5
#     init_filters = 32
#     cnn = DonaldDuckConv.DonaldDuckCNN(
#          dataset,
#          epochs=5,
#     )
#     cnn.setModel(
#          conv_layers_num=conv_layers_num,
#          filters=init_filters,
#          kernel_size=(3,3)
#     )
    
    cnn.fitModel()
    cnn.saveModelWeights(cnn.name+'.h5')

